/*** 1.   ũƮ ***/

SELECT NO, DATE
	, CASE WHEN high=1 THEN 'Berlin' WHEN high=8 AND RIGHT(NO,3)=000 THEN 'Paris' 
	  ELSE 'London' END AS CITY 
INTO TB_CITY
FROM (SELECT ROW_NUMBER() OVER (ORDER BY A.number) AS NO
	      , CONVERT(CHAR(8), DATEADD (DD, A.number,'2020-01-01'), 112) AS DATE
	      , high
	 FROM master..spt_values A, (SELECT number 
				  FROM master..spt_values 
				  WHERE type = 'P' AND number < 500) B
	 WHERE A.type = 'P'
) A

CREATE CLUSTERED INDEX CIDX_CITY ON TB_CITY(NO)
CREATE INDEX NIDX01_CITY ON TB_CITY(CITY)
GO

-- ν  
CREATE PROCEDURE SP_CITY @CITY VARCHAR(20)
AS 
SELECT CITY, COUNT(*)
FROM TB_CITY 
WHERE CITY IN (@CITY)
AND DATE > '20200130'
GROUP BY CITY
GO


/*** 2. [AS-IS] SQL    ȹ ***/

EXEC SP_CITY 'Paris'
EXEC SP_CITY 'London'
GO


/*** 6. [TO-BE]   ***/

--ε   
CREATE INDEX NIDX02_CITY ON TB_CITY(CITY, DATE)
GO

--SQL 
EXEC SP_CITY 'Paris'
EXEC SP_CITY 'London'
GO